/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.skill.SkillState;

public class CategoryData {
    private final Set<String> unlockedSkills;
    private boolean unlocked;
    private int extraPoints;
    private int earnedExperience;

    private CategoryData(Set<String> unlockedSkills, boolean unlocked, int extraPoints, int earnedExperience) {
        this.unlockedSkills = unlockedSkills;
        this.unlocked = unlocked;
        this.extraPoints = extraPoints;
        this.earnedExperience = earnedExperience;
    }

    public static CategoryData create(boolean unlocked) {
        return new CategoryData(new HashSet<String>(), unlocked, 0, 0);
    }

    public static CategoryData read(CompoundTag nbt) {
        boolean unlocked = nbt.m_128471_("unlocked");
        int points = nbt.m_128451_("points");
        int experience = nbt.m_128451_("experience");
        HashSet<String> unlockedSkills = new HashSet<String>();
        ListTag unlockedNbt = nbt.m_128437_("unlocked_skills", 8);
        for (Tag elementNbt : unlockedNbt) {
            if (!(elementNbt instanceof StringTag)) continue;
            StringTag stringNbt = (StringTag)elementNbt;
            unlockedSkills.add(stringNbt.m_7916_());
        }
        return new CategoryData(unlockedSkills, unlocked, points, experience);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.m_128379_("unlocked", this.unlocked);
        nbt.m_128405_("points", this.extraPoints);
        nbt.m_128405_("experience", this.earnedExperience);
        ListTag unlockedNbt = new ListTag();
        for (String skill : this.unlockedSkills) {
            unlockedNbt.add((Object)StringTag.m_129297_((String)skill));
        }
        nbt.m_128365_("unlocked_skills", (Tag)unlockedNbt);
        return nbt;
    }

    public SkillState getSkillState(CategoryConfig category, SkillConfig skill) {
        if (this.unlockedSkills.contains(skill.getId())) {
            return SkillState.UNLOCKED;
        }
        if (category.getConnections().getExclusive().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().anyMatch(this.unlockedSkills::contains)).orElse(false).booleanValue()) {
            return SkillState.EXCLUDED;
        }
        if (category.getConnections().getNormal().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().anyMatch(this.unlockedSkills::contains)).orElse(true).booleanValue()) {
            return SkillState.AVAILABLE;
        }
        if (skill.isRoot()) {
            if (!category.getGeneral().isExclusiveRoot()) {
                return SkillState.AVAILABLE;
            }
            if (this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).stream()).noneMatch(SkillConfig::isRoot)) {
                return SkillState.AVAILABLE;
            }
        }
        return SkillState.LOCKED;
    }

    public boolean tryUnlockSkill(CategoryConfig category, ServerPlayer player, String skillId, boolean force) {
        return category.getSkills().getById(skillId).flatMap(skill -> {
            String definitionId = skill.getDefinitionId();
            return category.getDefinitions().getById(definitionId).map(definition -> {
                if (force) {
                    this.addExtraPoints(definition.getCost());
                } else {
                    if (this.getSkillState(category, (SkillConfig)skill) != SkillState.AVAILABLE) {
                        return false;
                    }
                    if (this.getPointsLeft(category) < Math.max(definition.getRequiredPoints(), definition.getCost())) {
                        return false;
                    }
                    if (this.getSpentPoints(category) < definition.getRequiredSpentPoints()) {
                        return false;
                    }
                }
                this.unlockSkill(skillId);
                int count = this.countUnlocked(category, definitionId);
                for (SkillRewardConfig reward : definition.getRewards()) {
                    reward.getInstance().update(player, new RewardContext(count, true));
                }
                return true;
            });
        }).orElse(false);
    }

    public int countUnlocked(CategoryConfig category, String definitionId) {
        return (int)category.getSkills().getAll().stream().filter(skill -> skill.getDefinitionId().equals(definitionId)).filter(skill -> this.getSkillState(category, (SkillConfig)skill) == SkillState.UNLOCKED).count();
    }

    public void refreshReward(CategoryConfig category, ServerPlayer player, ResourceLocation type) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            int count = this.countUnlocked(category, definition.getId());
            for (SkillRewardConfig reward : definition.getRewards()) {
                if (!reward.getType().equals((Object)type)) continue;
                reward.getInstance().update(player, new RewardContext(count, false));
            }
        }
    }

    public void applyRewards(CategoryConfig category, ServerPlayer player) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            int count = this.countUnlocked(category, definition.getId());
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(player, new RewardContext(count, false));
            }
        }
    }

    public void unlockSkill(String id) {
        this.unlockedSkills.add(id);
    }

    public void resetSkills() {
        this.unlockedSkills.clear();
    }

    public void addExperience(int experience) {
        this.earnedExperience += experience;
    }

    public Set<String> getUnlockedSkillIds() {
        return this.unlockedSkills;
    }

    public int getEarnedExperience() {
        return this.earnedExperience;
    }

    public void setEarnedExperience(int earnedExperience) {
        this.earnedExperience = earnedExperience;
    }

    public int getCurrentLevel(CategoryConfig category) {
        return category.getExperience().map(experience -> experience.getCurrentLevel(this.earnedExperience)).orElse(0);
    }

    public int getCurrentExperience(CategoryConfig category) {
        return category.getExperience().map(experience -> experience.getCurrentExperience(this.earnedExperience)).orElse(0);
    }

    public int getRequiredExperience(CategoryConfig category) {
        return category.getExperience().map(experience -> experience.getRequiredExperience(this.getCurrentLevel(category))).orElse(0);
    }

    public int getPointsForExperience(CategoryConfig category) {
        if (category.getExperience().isPresent()) {
            return this.getCurrentLevel(category);
        }
        return 0;
    }

    public int getSpentPoints(CategoryConfig category) {
        return this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).flatMap(skill -> category.getDefinitions().getById(skill.getDefinitionId())).stream()).mapToInt(SkillDefinitionConfig::getCost).sum();
    }

    public int getEarnedPoints(CategoryConfig category) {
        return this.getExtraPoints() + this.getPointsForExperience(category);
    }

    public int getPointsLeft(CategoryConfig category) {
        return Math.min(this.getEarnedPoints(category), this.getSpentPointsLimit(category)) - this.getSpentPoints(category);
    }

    public int getSpentPointsLimit(CategoryConfig category) {
        return category.getGeneral().getSpentPointsLimit();
    }

    public void addExtraPoints(int count) {
        this.extraPoints += count;
    }

    public int getExtraPoints() {
        return this.extraPoints;
    }

    public void setExtraPoints(int points) {
        this.extraPoints = points;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(boolean unlocked) {
        this.unlocked = unlocked;
    }
}

